using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using CANNEDCOMMENT = gov.va.med.vbecs.Common.VbecsTables.CannedComment;
using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{

		#region Header

		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
		///<summary>
		///UI dialog, allowing users to override a restriction on the selection of a unit for modification
		///</summary>

		#endregion

	public class DlgExpiredUnitConfirm : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		/// <summary>
		/// Blood unit to display
		/// </summary>
		private BOL.BloodUnit _bloodUnit;
		private bool _detailsRequired = false;


		#region Form Controls

		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpConfirm;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnVerify;
		private System.Windows.Forms.TextBox txtComment;
		private System.Windows.Forms.TextBox txtUnitID;
		private System.Windows.Forms.Label lblUnitID;
		private System.Windows.Forms.GroupBox grpIcon;
		private System.Windows.Forms.Label lblWarningMessage;
		private System.Windows.Forms.TextBox txtProductName;
		private System.Windows.Forms.Label lblProductName;
		private System.Windows.Forms.TextBox txtABORh;
		private System.Windows.Forms.Label lblABORh;
		private System.Windows.Forms.TextBox txtExpirationDate;
		private System.Windows.Forms.Label lblExpirationDate;
		private System.Windows.Forms.PictureBox picWarning;
		private System.Windows.Forms.ToolTip toolTip1;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.Windows.Forms.Label lblComment;
		private System.Windows.Forms.Label lblDetails;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors/Destructors

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// DlgExpiredUnitConfirm constructor
		/// </summary>
		[Obsolete]
		public DlgExpiredUnitConfirm()
		{		
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			//
			SetComponentProperties();
		}


		/// <summary>
		/// Constructor with parrameters so the developer doesn't have to remember to set them later
		/// </summary>
		/// <param name="bloodUnit"></param>
		/// <param name="confirmationMessage"></param>
		public DlgExpiredUnitConfirm(BOL.BloodUnit bloodUnit, string confirmationMessage)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			this.BloodUnit = bloodUnit;		//Setting the property because it fires PopulateForm
			this.lblWarningMessage.Text = confirmationMessage;

			// **** 508 Compliance ***
			if ( Common.LogonUser.IsVisuallyImpairedUser )
			{
				Common.Utility.Speak( this.lblWarningMessage.Text );
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgExpiredUnitConfirm));
			this.btnVerify = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpConfirm = new System.Windows.Forms.GroupBox();
			this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblComment = new System.Windows.Forms.Label();
			this.txtABORh = new System.Windows.Forms.TextBox();
			this.lblABORh = new System.Windows.Forms.Label();
			this.txtExpirationDate = new System.Windows.Forms.TextBox();
			this.lblExpirationDate = new System.Windows.Forms.Label();
			this.txtComment = new System.Windows.Forms.TextBox();
			this.lblDetails = new System.Windows.Forms.Label();
			this.txtProductName = new System.Windows.Forms.TextBox();
			this.txtUnitID = new System.Windows.Forms.TextBox();
			this.lblProductName = new System.Windows.Forms.Label();
			this.lblUnitID = new System.Windows.Forms.Label();
			this.lblWarningMessage = new System.Windows.Forms.Label();
			this.grpIcon = new System.Windows.Forms.GroupBox();
			this.picWarning = new System.Windows.Forms.PictureBox();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.grpConfirm.SuspendLayout();
			this.grpIcon.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(394, 30);
			this.vbecsLogo1.TabIndex = 3;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 371);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 5;
			// 
			// btnVerify
			// 
			this.btnVerify.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnVerify.EnabledButton = false;
			this.btnVerify.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnVerify.Image = null;
			this.btnVerify.Location = new System.Drawing.Point(234, 362);
			this.btnVerify.Name = "btnVerify";
			this.btnVerify.Size = new System.Drawing.Size(75, 23);
			this.btnVerify.TabIndex = 1;
			this.btnVerify.Click += new System.EventHandler(this.btnVerify_Click);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(314, 362);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "&Cancel";
			// 
			// grpConfirm
			// 
			this.grpConfirm.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpConfirm.Controls.Add(this.cmbComment);
			this.grpConfirm.Controls.Add(this.lblComment);
			this.grpConfirm.Controls.Add(this.txtABORh);
			this.grpConfirm.Controls.Add(this.lblABORh);
			this.grpConfirm.Controls.Add(this.txtExpirationDate);
			this.grpConfirm.Controls.Add(this.lblExpirationDate);
			this.grpConfirm.Controls.Add(this.txtComment);
			this.grpConfirm.Controls.Add(this.lblDetails);
			this.grpConfirm.Controls.Add(this.txtProductName);
			this.grpConfirm.Controls.Add(this.txtUnitID);
			this.grpConfirm.Controls.Add(this.lblProductName);
			this.grpConfirm.Controls.Add(this.lblUnitID);
			this.grpConfirm.Controls.Add(this.lblWarningMessage);
			this.grpConfirm.Location = new System.Drawing.Point(64, 36);
			this.grpConfirm.Name = "grpConfirm";
			this.grpConfirm.Size = new System.Drawing.Size(324, 318);
			this.grpConfirm.TabIndex = 0;
			this.grpConfirm.TabStop = false;
			// 
			// cmbComment
			// 
			this.cmbComment.AccessibleDescription = "Comment";
			this.cmbComment.AccessibleName = "Comment";
			this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbComment.Interval = 100;
			this.cmbComment.Location = new System.Drawing.Point(88, 168);
			this.cmbComment.Name = "cmbComment";
			this.cmbComment.Size = new System.Drawing.Size(220, 22);
			this.cmbComment.TabIndex = 10;
			this.cmbComment.TextChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
			this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
			// 
			// lblComment
			// 
			this.lblComment.Location = new System.Drawing.Point(12, 168);
			this.lblComment.Name = "lblComment";
			this.lblComment.Size = new System.Drawing.Size(60, 20);
			this.lblComment.TabIndex = 9;
			this.lblComment.Text = "Comment*";
			this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtABORh
			// 
			this.txtABORh.AccessibleDescription = "A B O R H";
			this.txtABORh.AccessibleName = "A B O R H";
			this.txtABORh.Location = new System.Drawing.Point(88, 116);
			this.txtABORh.Name = "txtABORh";
			this.txtABORh.ReadOnly = true;
			this.txtABORh.Size = new System.Drawing.Size(96, 20);
			this.txtABORh.TabIndex = 6;
			this.txtABORh.Text = "";
			// 
			// lblABORh
			// 
			this.lblABORh.Location = new System.Drawing.Point(12, 116);
			this.lblABORh.Name = "lblABORh";
			this.lblABORh.Size = new System.Drawing.Size(72, 20);
			this.lblABORh.TabIndex = 5;
			this.lblABORh.Text = "ABO/Rh";
			this.lblABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtExpirationDate
			// 
			this.txtExpirationDate.AccessibleDescription = "Expiration Date";
			this.txtExpirationDate.AccessibleName = "Expiration Date";
			this.txtExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtExpirationDate.Location = new System.Drawing.Point(88, 140);
			this.txtExpirationDate.Name = "txtExpirationDate";
			this.txtExpirationDate.ReadOnly = true;
			this.txtExpirationDate.Size = new System.Drawing.Size(220, 20);
			this.txtExpirationDate.TabIndex = 8;
			this.txtExpirationDate.Text = "";
			// 
			// lblExpirationDate
			// 
			this.lblExpirationDate.Location = new System.Drawing.Point(12, 140);
			this.lblExpirationDate.Name = "lblExpirationDate";
			this.lblExpirationDate.Size = new System.Drawing.Size(84, 20);
			this.lblExpirationDate.TabIndex = 7;
			this.lblExpirationDate.Text = "Expiration Date";
			this.lblExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtComment
			// 
			this.txtComment.AcceptsReturn = true;
			this.txtComment.AccessibleDescription = "Details";
			this.txtComment.AccessibleName = "Details";
			this.txtComment.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtComment.Location = new System.Drawing.Point(88, 196);
			this.txtComment.MaxLength = 255;
			this.txtComment.Multiline = true;
			this.txtComment.Name = "txtComment";
			this.txtComment.ScrollBars = System.Windows.Forms.ScrollBars.Vertical;
			this.txtComment.Size = new System.Drawing.Size(216, 112);
			this.txtComment.TabIndex = 12;
			this.txtComment.Text = "";
			this.txtComment.TextChanged += new System.EventHandler(this.txtComment_TextChanged);
			// 
			// lblDetails
			// 
			this.lblDetails.Location = new System.Drawing.Point(12, 196);
			this.lblDetails.Name = "lblDetails";
			this.lblDetails.Size = new System.Drawing.Size(76, 24);
			this.lblDetails.TabIndex = 11;
			this.lblDetails.Text = "Details";
			this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtProductName
			// 
			this.txtProductName.AccessibleDescription = "Product Name";
			this.txtProductName.AccessibleName = "Product Name";
			this.txtProductName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtProductName.Location = new System.Drawing.Point(88, 92);
			this.txtProductName.Name = "txtProductName";
			this.txtProductName.ReadOnly = true;
			this.txtProductName.Size = new System.Drawing.Size(220, 20);
			this.txtProductName.TabIndex = 4;
			this.txtProductName.Text = "";
			// 
			// txtUnitID
			// 
			this.txtUnitID.AccessibleDescription = "Unit I D";
			this.txtUnitID.AccessibleName = "Unit I D";
			this.txtUnitID.Location = new System.Drawing.Point(88, 64);
			this.txtUnitID.Name = "txtUnitID";
			this.txtUnitID.ReadOnly = true;
			this.txtUnitID.Size = new System.Drawing.Size(96, 20);
			this.txtUnitID.TabIndex = 2;
			this.txtUnitID.Text = "";
			// 
			// lblProductName
			// 
			this.lblProductName.Location = new System.Drawing.Point(12, 92);
			this.lblProductName.Name = "lblProductName";
			this.lblProductName.Size = new System.Drawing.Size(80, 20);
			this.lblProductName.TabIndex = 3;
			this.lblProductName.Text = "Product Name";
			this.lblProductName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblUnitID
			// 
			this.lblUnitID.Location = new System.Drawing.Point(12, 64);
			this.lblUnitID.Name = "lblUnitID";
			this.lblUnitID.Size = new System.Drawing.Size(72, 20);
			this.lblUnitID.TabIndex = 1;
			this.lblUnitID.Text = "Unit ID";
			this.lblUnitID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblWarningMessage
			// 
			this.lblWarningMessage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lblWarningMessage.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.lblWarningMessage.Location = new System.Drawing.Point(8, 8);
			this.lblWarningMessage.Name = "lblWarningMessage";
			this.lblWarningMessage.Size = new System.Drawing.Size(308, 56);
			this.lblWarningMessage.TabIndex = 0;
			this.lblWarningMessage.Text = "Use ConfirmationMessage property to set text here";
			this.lblWarningMessage.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// grpIcon
			// 
			this.grpIcon.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpIcon.Controls.Add(this.picWarning);
			this.grpIcon.Location = new System.Drawing.Point(4, 36);
			this.grpIcon.Name = "grpIcon";
			this.grpIcon.Size = new System.Drawing.Size(56, 318);
			this.grpIcon.TabIndex = 4;
			this.grpIcon.TabStop = false;
			// 
			// picWarning
			// 
			this.picWarning.Image = ((System.Drawing.Image)(resources.GetObject("picWarning.Image")));
			this.picWarning.Location = new System.Drawing.Point(4, 12);
			this.picWarning.Name = "picWarning";
			this.picWarning.Size = new System.Drawing.Size(45, 45);
			this.picWarning.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picWarning.TabIndex = 0;
			this.picWarning.TabStop = false;
			// 
			// DlgExpiredUnitConfirm
			// 
			this.AcceptButton = this.btnVerify;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(394, 387);
			this.Controls.Add(this.grpIcon);
			this.Controls.Add(this.grpConfirm);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnVerify);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.hlphelpChm.SetHelpKeyword(this, "Modify_Unit.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(400, 328);
			this.Name = "DlgExpiredUnitConfirm";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Verify Unit Selection";
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgExpiredUnitConfirm_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.btnVerify, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpConfirm, 0);
			this.Controls.SetChildIndex(this.grpIcon, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpConfirm.ResumeLayout(false);
			this.grpIcon.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		/// <summary>
		/// Returns the comments from the Comment combo box appended to any text in the 
		/// Details test box
		/// </summary>
		public string Comment
		{
			get
			{
				string comment = "";
				if (this.cmbComment.SelectedIndex>-1)
				{
					if (this.cmbComment.Text.Trim().ToUpper() != "OTHER")
					{
						comment	= this.cmbComment.Text;
					}
					if (this.txtComment.Text.Trim().Length>0)
					{
						if ((comment.Length>0) && (comment[comment.Length-1] != '.'))
						{
							comment = comment + ". ";
						}
						comment = comment + this.txtComment.Text;
					}
				}
				return comment;
			}
		}


		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Sets title to display on form
		/// </summary>
		public string Title
		{
			set
			{
				this.vbecsLogo1.Title = value;
				this.Text = "VBECS - "+value;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Gets or sets the blood unit to display for override
		/// </summary>
		public BOL.BloodUnit BloodUnit
		{
			get
			{
				return this._bloodUnit;
			}
			set
			{
				this._bloodUnit = value;
				//
				PopulateForm();
			}
		}

		#endregion

		#region Methods/Functions

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to initialize UI control properties
		/// </summary>
		private void SetComponentProperties()
		{
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			this.vbecsLogo1.Title = "Verify Unit Selection";
			//
			this.RequiredFieldsLabel = true;
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC025.DlgExpiredUnitConfirm());
			//
			this.btnVerify.Text = "&Override";
			this.btnVerify.EnabledButton = false;

			System.Data.DataTable dtData = BOL.CannedComment.GetCannedComments("UM");
			
			foreach(System.Data.DataRow drComment in dtData.Rows)
			{
				this.cmbComment.Items.Add(drComment[CANNEDCOMMENT.CannedCommentText].ToString());
			}

		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Private method to load UI controls with blood unit properties
		/// </summary>
		private void PopulateForm()
		{
			this.txtUnitID.Text = this._bloodUnit.EyeReadableUnitId;
			//this.txtProductName.Text = this.BloodUnit.ProductShortName;
			this.txtProductName.Text = this._bloodUnit.ProductShortName;

			this.toolTip1.SetToolTip(this.txtProductName,this._bloodUnit.ProductName);
			this.txtABORh.Text = this._bloodUnit.BloodUnitMedia.AboRh.AboRHText;
			this.txtExpirationDate.Text = Common.VBECSDateTime.FormatDateTimeString(this._bloodUnit.BloodUnitMedia.UnitExpirationDate);
			this.txtComment.Text = string.Empty;
		}


		private void CheckIfDetailsRequired()
		{
			//Details required if Comment = Other
			if (this.cmbComment.Text.Trim().ToUpper() == "OTHER")
			{
				this.lblDetails.Text = "Details*";
				this._detailsRequired = true;
			}
			else
			{
				this.lblDetails.Text = "Details";
				this._detailsRequired = false;
			}
		}

		#endregion

		#region Events/EventHandlers

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>1/30/2003</CreationDate>
		///
		/// <summary>
		/// Comment text box text changed event handler, sets comments property of blood unit
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void txtComment_TextChanged(object sender, System.EventArgs e)
		{
			try
			{
				this._bloodUnit.BloodUnitMedia.Comments = this.Comment;
				this.errError.SetVbecsError(this.txtComment, string.Empty); // **** 508 Compliance ***
			}
			catch (Exception err)
			{
				this.errError.SetVbecsError(this.txtComment, err.Message); // **** 508 Compliance ***
			}

			this.CheckValid();
		}

		/// <summary>
		/// Verify button click event, closes dialog with OK result
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnVerify_Click(object sender, System.EventArgs e)
		{
			this._bloodUnit.BloodUnitMedia.Comments = this.Comment;
			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		/// <summary>
		/// CheckValid
		/// </summary>
		private void CheckValid()
		{
			if (_detailsRequired)
			{
				btnVerify.EnabledButton = (this.txtComment.Text.Trim().Length > 0);
				if (!btnVerify.EnabledButton) 
				{
					this.ttToolTip.SetToolTip(btnVerify, Common.StrRes.Tooltips.Common.CommentRequiredWithOther().ResString);
				}
			}
			else
			{
				btnVerify.EnabledButton = (this.cmbComment.SelectedIndex >- 1);
				// **** 508 Compliance ***
				if (!btnVerify.EnabledButton) 
				{
					this.ttToolTip.SetToolTip(btnVerify, Common.StrRes.Tooltips.Common.CommentRequired().ResString);
				}
				else
				{
					this.ttToolTip.SetToolTip(btnVerify, string.Empty);
				}
			}
		}

		private void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.CheckIfDetailsRequired();
			this.CheckValid();
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgExpiredUnitConfirm_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			if ( !this.btnVerify.EnabledButton )
			{
				CheckIfDetailsRequired();
				//
				CheckValid();
				//
				this.SpeakMessage( this.ttToolTip.GetToolTip(btnVerify) );
			}

		}

		#endregion
	}
}

